var gIdleAnimations = new Array();

function DoesPersonExist(person) {
  if (!IsMapEngineRunning())
    return false;

  var person_list = GetPersonList();
  for (var i = 0; i < person_list.length; ++i)
    if (person_list[i] == person)
      return true;

  return false;
}

function IdleAnimation(person, repeat_count, repeat_forever) {
  this.person = person;
  this.spriteset = GetPersonSpriteset(person);
  this.repeat_count = repeat_count;
  this.repeat_forever = repeat_forever;
  this.direction_name = GetPersonDirection(person);
  this.direction_index = 0;
  this.frame = GetPersonFrame(person);
  this.next_update = GetTime() + this.getDelay();
}

IdleAnimation.prototype.getDelay = function() {
  if (this.direction_index >= 0 && this.frame >= 0)
    return this.spriteset.directions[this.direction_index].frames[this.frame].delay * 10;
  return -1;
}

IdleAnimation.prototype.getMaxFrames = function() {

  this.direction_index = 0;

  for (var i = 0; i < this.spriteset.directions.length; ++i) {
    if (this.spriteset.directions[i].name == this.direction_name) {
      this.direction_index = i;
      break;
    }
  }

  if (this.direction_index >= 0 && this.frame >= 0)
    return this.spriteset.directions[this.direction_index].frames.length;
  return -1;
}

function SetPersonIdleAnimation(person, repeat_count, repeat_forever) {
  if (IsPersonInIdleAnimation(person)) {
    gIdleAnimations[GetPersonIdleAnimationIndex(person)].repeat_count = repeat_count;
    gIdleAnimations[GetPersonIdleAnimationIndex(person)].repeat_forever = repeat_forever; 
  }
  else {
    gIdleAnimations.push (new IdleAnimation(person, repeat_count, repeat_forever));
  }

  return true;
}

function IsPersonInIdleAnimation(person) {
  return (GetPersonIdleAnimationIndex(person) > -1);
}

function GetPersonIdleAnimationIndex(person) {
  for (var i = 0; i < gIdleAnimations.length; ++i)
    if (gIdleAnimations[i].person == person)
      return i;
  return -1;
}

function UpdatePersonIdleAnimations() {

  for (var i = 0; i < gIdleAnimations.length; ++i) {
    var person = gIdleAnimations[i].person;

    if (GetTime() > gIdleAnimations[i].next_update) {
      var okay = true;
     
      if (!DoesPersonExist(person)) {
        okay = false;
      } 

      if (okay) {
        gIdleAnimations[i].frame += 1;
        if (gIdleAnimations[i].frame >= gIdleAnimations[i].getMaxFrames()) {
          gIdleAnimations[i].repeat_count -= 1;
          gIdleAnimations[i].frame = 0;
          if (gIdleAnimations[i].repeat_count <= 0) {
            okay = false;
            if (gIdleAnimations[i].repeat_forever) {
              okay = true;
            }
          }
        }
      }
      
      if (okay) {
        gIdleAnimations[i].next_update = GetTime() + gIdleAnimations[i].getDelay();
        SetPersonFrame(person, gIdleAnimations[i].frame);
      }
    }
  }
}